# 画面設計書 1-エラーページ (_error)

## 概要

Pages Routerにおけるデフォルトのエラーページコンポーネントの設計書。HTTPステータスコードに応じたエラーメッセージを表示するフォールバック画面である。

### 本画面の処理概要

**業務上の目的・背景**：Webアプリケーションでは、リクエストの処理中にサーバーエラーやルーティングエラーが発生する場合がある。この画面は、Pages Routerを使用するNext.jsアプリケーションにおいて、エラー発生時にユーザーに対して適切なHTTPステータスコードとエラーメッセージを表示するためのデフォルトフォールバック画面である。ユーザーが独自の`_error.tsx`を作成しない場合、本コンポーネントが自動的に使用される。これにより、未処理のエラーが発生してもユーザーに白画面ではなく意味のあるエラー情報を提示できる。

**画面へのアクセス方法**：本画面は直接URLでアクセスするものではなく、Next.jsランタイムがエラーを検出した際に自動的に表示される。サーバーサイドでは`res.statusCode`から、クライアントサイドでは`err.statusCode`からステータスコードを取得し、対応するエラーメッセージを表示する。

**主要な操作・処理内容**：
1. `getInitialProps`でリクエスト/レスポンスオブジェクトまたはエラーオブジェクトからHTTPステータスコードを取得する
2. ステータスコードに対応するエラータイトル（400: Bad Request, 404: This page could not be found, 405: Method Not Allowed, 500: Internal Server Error）をマッピングテーブルから取得する
3. ステータスコードとエラーメッセージを画面中央に表示する（h1にステータスコード、h2にメッセージ）
4. ダークモード対応のスタイルを適用する（`prefers-color-scheme: dark`メディアクエリ使用）
5. ステータスコードが存在しない場合、クライアントサイド例外メッセージ「Application error: a client-side exception has occurred」を表示する

**画面遷移**：
- 遷移元：Pages Routerのルーティング処理中にエラーが発生した場合、`_app`コンポーネント経由で本画面が表示される
- 遷移先：特になし（エラー表示のみ）

**権限による表示制御**：権限による表示制御は行わない。全ユーザーに対して同一のエラー表示を行う。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 33 | カスタムエラーページ | 主機能 | HTTPステータスコード（400, 404, 405, 500等）に応じたエラーメッセージ表示の主処理 |
| 26 | Pages Router | 補助機能 | Pages Routerのルーティング機構を通じてエラーページを表示 |
| 34 | サーバーサイドレンダリング（SSR） | 補助機能 | getInitialPropsによるステータスコード取得とサーバーサイドレンダリング |

## 画面種別

エラー表示（フォールバック画面）

## URL/ルーティング

Pages Routerのエラーハンドリングにより自動表示。特定のURLパターンは持たず、任意のページでエラーが発生した際にそのページのURLのまま表示される。

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|------|------|------|
| statusCode | 入力 | number | はい | HTTPステータスコード。`res.statusCode`、`err.statusCode`、またはデフォルト値404から取得 |
| hostname | 入力 | string | いいえ | クライアントサイドの場合は`window.location.hostname`、サーバーサイドの場合はリクエストURLから取得 |
| title | 入力 | string | いいえ | カスタムエラータイトル。未指定の場合はstatusCodesマッピングから取得 |
| withDarkMode | 入力 | boolean | いいえ | ダークモード対応CSSを有効にするか（デフォルト: true） |

## 表示項目

| 項目名 | 表示位置 | 説明 |
|--------|----------|------|
| ステータスコード | h1要素（左側） | HTTPステータスコードを数値で表示。ステータスコードが存在しない場合は非表示 |
| エラーメッセージ | h2要素（右側） | ステータスコードに対応するメッセージ。コード不明の場合は「An unexpected error has occurred」 |
| ページタイトル | titleタグ | ステータスコードがある場合「{code}: {title}」、ない場合「Application error: a client-side exception has occurred」 |

## イベント仕様

### 1-なし

本画面にはユーザー操作可能なインタラクティブ要素は存在しない。表示のみの静的なエラーページである。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| なし | - | - | 本画面はデータベースへのアクセスを行わない |

### テーブル別更新項目詳細

データベース操作なし。

## メッセージ仕様

| メッセージID | 種別 | 条件 | メッセージ内容 |
|-------------|------|------|----------------|
| ERR-400 | エラー | statusCode=400 | Bad Request |
| ERR-404 | エラー | statusCode=404 | This page could not be found |
| ERR-405 | エラー | statusCode=405 | Method Not Allowed |
| ERR-500 | エラー | statusCode=500 | Internal Server Error |
| ERR-DEFAULT | エラー | 上記以外のstatusCode | An unexpected error has occurred |
| ERR-CLIENT | エラー | statusCodeなし | Application error: a client-side exception has occurred (see the browser console for more information) |

## 例外処理

| 例外条件 | 挙動 |
|----------|------|
| statusCodeが未定義 | デフォルト値として404を使用 |
| titleが未指定かつstatusCodesにマッピングなし | 「An unexpected error has occurred」を表示 |
| ステータスコードもタイトルも存在しない場合 | クライアントサイド例外メッセージを表示し、hostnameが取得可能な場合はそれも併記 |

## 備考

- 本コンポーネントはReact.Componentクラスを継承したクラスコンポーネントとして実装されている
- `displayName`は`ErrorPage`に設定されている
- `origGetInitialProps`に元のgetInitialProps関数が保持されており、ユーザーがオーバーライドした場合でも元の実装にアクセス可能
- ダークモード対応は`withDarkMode`プロパティ（デフォルトtrue）で制御可能
- CSSはインラインスタイルとminified CSSの組み合わせで実装されており、外部CSSファイルへの依存がない

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、エラーページで使用されるプロパティの型定義を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | _error.tsx | `packages/next/src/pages/_error.tsx` | L12-17: `ErrorProps`型の定義（statusCode, hostname, title, withDarkMode） |
| 1-2 | utils.ts | `packages/next/src/shared/lib/utils.ts` | L120-161: `NextPageContext`インターフェース（req, res, err, pathname等） |

**読解のコツ**: `ErrorProps`はシンプルな4フィールドの型である。`statusCode`のみが必須で、他はオプショナル。

#### Step 2: エントリーポイントを理解する

処理の起点となる`getInitialProps`と`render`メソッドを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | _error.tsx | `packages/next/src/pages/_error.tsx` | L19-43: `_getInitialProps`関数 - ステータスコードとホスト名の取得ロジック |
| 2-2 | _error.tsx | `packages/next/src/pages/_error.tsx` | L81-156: `Error`クラスの`render`メソッド - 画面表示のレンダリング |

**主要処理フロー**:
1. **L24-25**: `res.statusCode` → `err.statusCode` → `404` の優先順位でステータスコードを決定
2. **L29-40**: サーバーサイドの場合は`getRequestMeta`でリクエストURLからホスト名を取得、クライアントサイドの場合は`window.location.hostname`を使用
3. **L88**: `withDarkMode`プロパティのデフォルト値をtrueに設定
4. **L89-92**: タイトルの決定ロジック（props.title → statusCodesマッピング → デフォルトメッセージ）
5. **L96-154**: JSXによるUI描画（Headコンポーネントでtitleを設定、ステータスコードとメッセージを表示）

#### Step 3: スタイル定義を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | _error.tsx | `packages/next/src/pages/_error.tsx` | L45-76: `styles`オブジェクト - 画面中央配置のFlexboxレイアウト定義 |
| 3-2 | _error.tsx | `packages/next/src/pages/_error.tsx` | L5-10: `statusCodes`マッピング - ステータスコードとメッセージの対応表 |

#### Step 4: Headコンポーネントとの連携を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | head.tsx | `packages/next/src/shared/lib/head.tsx` | L153-163: `Head`コンポーネント - `<head>`タグへの要素注入処理 |

### プログラム呼び出し階層図

```
Next.js Router (エラー検出)
    |
    +-- _app.tsx (AppコンポーネントがErrorPageをレンダリング)
           |
           +-- _error.tsx :: Error.getInitialProps()
           |      |
           |      +-- req/res/errからstatusCode取得
           |      +-- getRequestMeta() (サーバーサイド時)
           |
           +-- _error.tsx :: Error.render()
                  |
                  +-- next/head :: Head コンポーネント
                  +-- statusCodesマッピングからtitle取得
                  +-- インラインCSS + ダークモードCSS出力
```

### データフロー図

```
[入力]                    [処理]                          [出力]

NextPageContext ------> _getInitialProps() -------> ErrorProps
 (req, res, err)        |                           (statusCode,
                        +-- statusCode決定            hostname)
                        +-- hostname取得
                                                        |
                                                        v
ErrorProps ----------> Error.render() -----------> JSX (HTML)
 (statusCode,           |                          - <title>
  hostname,             +-- title決定               - <h1> statusCode
  title,                +-- CSS生成                 - <h2> message
  withDarkMode)         +-- JSX組立                 - inline CSS
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| _error.tsx | `packages/next/src/pages/_error.tsx` | ソース | エラーページのメインコンポーネント |
| head.tsx | `packages/next/src/shared/lib/head.tsx` | ソース | `<head>`タグへの要素注入コンポーネント |
| utils.ts | `packages/next/src/shared/lib/utils.ts` | ソース | NextPageContext型定義、loadGetInitialProps関数 |
| request-meta.ts | `packages/next/src/server/request-meta.ts` | ソース | サーバーサイドでのリクエストメタデータ取得 |
